#include "ScreenQuadPS_Rm.hlsl"
static const float MainSpheRadius = 4;//5.65; // 0.5 * squareroot(2) * HalfLedCubeSide;
float4 main( PS_INPUT input) : SV_Target
{
    class SphereDomain : LedDomain 
    { 
       bool IsOutside(in float3 p)
        {
            return any(p > LedCubeSide ) || any(p < 0 );
        }
    } sphereDomain;

    class OrbitalPlanet : IntensityProvider 
    {
        float IntensityAt(float3 p) 
        {
            float d = sdSphere(p, MainSpheRadius);
            float miniRadius = 1;
            d = _union(d, sdSphere(p - WorldAxis.X*1.5*MainSpheRadius, miniRadius));
            return d;

        }

    } orbitalPlanet ;


    class Spherescene : IntensityProvider 
    { 
        float IntensityAt(float3 p) 
        { 
            // we reset the cube
            if(SequenceRatio < 0.1)
                return 1 - 2*smoothstep(0, 0.1, SequenceRatio);

            // we bring the sphere up, in the cune
            if(SequenceRatio < 0.3)
            {
                float3 trans = (float3)HalfLedCubeSide;
                trans.y = -HalfLedCubeSide + smoothstep(0.1, 0.3, SequenceRatio)*LedCubeSide;
                return 1 - orbitalPlanet.IntensityAt(p-trans);
            }

            // we rotate it
            if(SequenceRatio < 0.9)
            {
                float t = smoothstep(0.3, 0.9, SequenceRatio) * -8 *Pi;
                p = HalfLedCubeSide+ rotateY(p - HalfLedCubeSide , t);
                return 1 - orbitalPlanet.IntensityAt(p - (float3)HalfLedCubeSide);
            }

            //// we move it down, outside of led cube
            float outfactor = smoothstep(0.9, 1., SequenceRatio);
            p = p-HalfLedCubeSide + outfactor*LedCubeSide*WorldAxis.Y;
            
            return  1 - orbitalPlanet.IntensityAt(p);
          
        }
    } sphereScene;

    class Cam : CamAnimator
    {
         float2x3 GetRays()
         {
            // UV --> input.Text.xy e [0 1]
            /*
            o---------X
            |
            |
            |
            |
            Y
            */

                      // Pixel position
            float2 pixel = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
                // pixel.xy e [-1 1], same orientation

            float3 startOffset = (1 - SequenceRatio) * float3(0.5, 0.75, .1*HalfLedCubeSide);

            float3 rayOrigin    = (float3)HalfLedCubeSide + startOffset;
            //rayOrigin.z += HalfLedCubeSide;
            rayOrigin.z += LedCubeSide + SequenceRatio * HalfLedCubeSide;
            float3 rayDirection = normalize(float3(pixel.x * ScreenRatio, -pixel.y, -1 - SequenceRatio));
    
            float t = SequenceRatio* 2 * Pi;
            rayOrigin = HalfLedCubeSide+ rotateY(rayOrigin - HalfLedCubeSide , t);
            rayDirection =  rotateY(rayDirection, t);

            float2x3 array = {rayOrigin, rayDirection};

            return array;
         }
    } cam;
    


   
   return rayMarcher(cam, sphereScene, sphereDomain);
}